/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.inventories.CreativeCrateBlock;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.content.schematics.packet.ConfigureSchematicannonPacket;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;

public class SchematicannonScreen
extends AbstractSimiContainerScreen<SchematicannonContainer> {
    private static final AllGuiTextures BG_BOTTOM = AllGuiTextures.SCHEMATICANNON_BOTTOM;
    private static final AllGuiTextures BG_TOP = AllGuiTextures.SCHEMATICANNON_TOP;
    private final class_2561 listPrinter = Lang.translateDirect("gui.schematicannon.listPrinter", new Object[0]);
    private final String _gunpowderLevel = "gui.schematicannon.gunpowderLevel";
    private final String _shotsRemaining = "gui.schematicannon.shotsRemaining";
    private final String _showSettings = "gui.schematicannon.showOptions";
    private final String _shotsRemainingWithBackup = "gui.schematicannon.shotsRemainingWithBackup";
    private final String _slotGunpowder = "gui.schematicannon.slot.gunpowder";
    private final String _slotListPrinter = "gui.schematicannon.slot.listPrinter";
    private final String _slotSchematic = "gui.schematicannon.slot.schematic";
    private final class_2561 optionEnabled = Lang.translateDirect("gui.schematicannon.optionEnabled", new Object[0]);
    private final class_2561 optionDisabled = Lang.translateDirect("gui.schematicannon.optionDisabled", new Object[0]);
    protected Vector<Indicator> replaceLevelIndicators;
    protected Vector<IconButton> replaceLevelButtons;
    protected IconButton skipMissingButton;
    protected Indicator skipMissingIndicator;
    protected IconButton skipTilesButton;
    protected Indicator skipTilesIndicator;
    protected IconButton playButton;
    protected Indicator playIndicator;
    protected IconButton pauseButton;
    protected Indicator pauseIndicator;
    protected IconButton resetButton;
    protected Indicator resetIndicator;
    private IconButton confirmButton;
    private IconButton showSettingsButton;
    private Indicator showSettingsIndicator;
    protected List<class_339> placementSettingWidgets;
    private final class_1799 renderedItem = AllBlocks.SCHEMATICANNON.asStack();
    private List<class_768> extraAreas = Collections.emptyList();

    public SchematicannonScreen(SchematicannonContainer container, class_1661 inventory, class_2561 title) {
        super(container, inventory, title);
        this.placementSettingWidgets = new ArrayList<class_339>();
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(SchematicannonScreen.BG_TOP.width, SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height + 2 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(-11, 0);
        super.method_25426();
        int x = this.field_2776;
        int y = this.field_2800;
        this.playButton = new IconButton(x + 75, y + 86, AllIcons.I_PLAY);
        this.playButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PLAY, true));
        this.playIndicator = new Indicator(x + 75, y + 79, Components.immutableEmpty());
        this.pauseButton = new IconButton(x + 93, y + 86, AllIcons.I_PAUSE);
        this.pauseButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PAUSE, true));
        this.pauseIndicator = new Indicator(x + 93, y + 79, Components.immutableEmpty());
        this.resetButton = new IconButton(x + 111, y + 86, AllIcons.I_STOP);
        this.resetButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.STOP, true));
        this.resetIndicator = new Indicator(x + 111, y + 79, Components.immutableEmpty());
        this.resetIndicator.state = Indicator.State.RED;
        this.addRenderableWidgets(new AbstractSimiWidget[]{this.playButton, this.playIndicator, this.pauseButton, this.pauseIndicator, this.resetButton, this.resetIndicator});
        this.confirmButton = new IconButton(x + 180, y + 117, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.field_22787.field_1724.method_7346());
        this.method_37063(this.confirmButton);
        this.showSettingsButton = new IconButton(x + 9, y + 117, AllIcons.I_PLACEMENT_SETTINGS);
        this.showSettingsButton.withCallback(() -> {
            this.showSettingsIndicator.state = this.placementSettingsHidden() ? Indicator.State.GREEN : Indicator.State.OFF;
            this.initPlacementSettings();
        });
        this.showSettingsButton.setToolTip((class_2561)Lang.translateDirect("gui.schematicannon.showOptions", new Object[0]));
        this.method_37063(this.showSettingsButton);
        this.showSettingsIndicator = new Indicator(x + 9, y + 111, Components.immutableEmpty());
        this.method_37063(this.showSettingsIndicator);
        this.extraAreas = ImmutableList.of((Object)new class_768(x + SchematicannonScreen.BG_TOP.width, y + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height - 62, 84, 92));
        this.method_25393();
    }

    private void initPlacementSettings() {
        this.removeWidgets(this.placementSettingWidgets);
        this.placementSettingWidgets.clear();
        if (this.placementSettingsHidden()) {
            return;
        }
        int x = this.field_2776;
        int y = this.field_2800;
        this.replaceLevelButtons = new Vector(4);
        this.replaceLevelIndicators = new Vector(4);
        ImmutableList icons = ImmutableList.of((Object)AllIcons.I_DONT_REPLACE, (Object)AllIcons.I_REPLACE_SOLID, (Object)AllIcons.I_REPLACE_ANY, (Object)AllIcons.I_REPLACE_EMPTY);
        ImmutableList toolTips = ImmutableList.of((Object)Lang.translateDirect("gui.schematicannon.option.dontReplaceSolid", new Object[0]), (Object)Lang.translateDirect("gui.schematicannon.option.replaceWithSolid", new Object[0]), (Object)Lang.translateDirect("gui.schematicannon.option.replaceWithAny", new Object[0]), (Object)Lang.translateDirect("gui.schematicannon.option.replaceWithEmpty", new Object[0]));
        for (int i = 0; i < 4; ++i) {
            this.replaceLevelIndicators.add(new Indicator(x + 33 + i * 18, y + 111, Components.immutableEmpty()));
            IconButton replaceLevelButton = new IconButton(x + 33 + i * 18, y + 117, (ScreenElement)icons.get(i));
            int replaceMode = i;
            replaceLevelButton.withCallback(() -> {
                if (((SchematicannonTileEntity)((SchematicannonContainer)this.field_2797).contentHolder).replaceMode != replaceMode) {
                    this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.values()[replaceMode], true);
                }
            });
            replaceLevelButton.setToolTip((class_2561)toolTips.get(i));
            this.replaceLevelButtons.add(replaceLevelButton);
        }
        this.placementSettingWidgets.addAll(this.replaceLevelButtons);
        this.placementSettingWidgets.addAll(this.replaceLevelIndicators);
        this.skipMissingButton = new IconButton(x + 111, y + 117, AllIcons.I_SKIP_MISSING);
        this.skipMissingButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_MISSING, !((SchematicannonTileEntity)((SchematicannonContainer)this.field_2797).contentHolder).skipMissing));
        this.skipMissingButton.setToolTip((class_2561)Lang.translateDirect("gui.schematicannon.option.skipMissing", new Object[0]));
        this.skipMissingIndicator = new Indicator(x + 111, y + 111, Components.immutableEmpty());
        Collections.addAll(this.placementSettingWidgets, this.skipMissingButton, this.skipMissingIndicator);
        this.skipTilesButton = new IconButton(x + 129, y + 117, AllIcons.I_SKIP_TILES);
        this.skipTilesButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_TILES, !((SchematicannonTileEntity)((SchematicannonContainer)this.field_2797).contentHolder).replaceTileEntities));
        this.skipTilesButton.setToolTip((class_2561)Lang.translateDirect("gui.schematicannon.option.skipTileEntities", new Object[0]));
        this.skipTilesIndicator = new Indicator(x + 129, y + 111, Components.immutableEmpty());
        Collections.addAll(this.placementSettingWidgets, this.skipTilesButton, this.skipTilesIndicator);
        this.addRenderableWidgets(this.placementSettingWidgets);
    }

    protected boolean placementSettingsHidden() {
        return this.showSettingsIndicator.state == Indicator.State.OFF;
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        SchematicannonTileEntity te = (SchematicannonTileEntity)((SchematicannonContainer)this.field_2797).contentHolder;
        if (!this.placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
                this.replaceLevelButtons.get((int)replaceMode).field_22763 = replaceMode != te.replaceMode;
                this.replaceLevelIndicators.get((int)replaceMode).state = replaceMode == te.replaceMode ? Indicator.State.ON : Indicator.State.OFF;
            }
            this.skipMissingIndicator.state = te.skipMissing ? Indicator.State.ON : Indicator.State.OFF;
            this.skipTilesIndicator.state = !te.replaceTileEntities ? Indicator.State.ON : Indicator.State.OFF;
        }
        this.playIndicator.state = Indicator.State.OFF;
        this.pauseIndicator.state = Indicator.State.OFF;
        this.resetIndicator.state = Indicator.State.OFF;
        switch (te.state) {
            case PAUSED: {
                this.pauseIndicator.state = Indicator.State.YELLOW;
                this.playButton.field_22763 = true;
                this.pauseButton.field_22763 = false;
                this.resetButton.field_22763 = true;
                break;
            }
            case RUNNING: {
                this.playIndicator.state = Indicator.State.GREEN;
                this.playButton.field_22763 = false;
                this.pauseButton.field_22763 = true;
                this.resetButton.field_22763 = true;
                break;
            }
            case STOPPED: {
                this.resetIndicator.state = Indicator.State.RED;
                this.playButton.field_22763 = true;
                this.pauseButton.field_22763 = false;
                this.resetButton.field_22763 = false;
                break;
            }
        }
        this.handleTooltips();
    }

    protected void handleTooltips() {
        if (this.placementSettingsHidden()) {
            return;
        }
        for (class_339 w : this.placementSettingWidgets) {
            IconButton button;
            if (!(w instanceof IconButton) || (button = (IconButton)w).getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((class_2561)TooltipHelper.holdShift(ItemDescription.Palette.Blue, SchematicannonScreen.method_25442()));
        }
        if (SchematicannonScreen.method_25442()) {
            this.fillToolTip(this.skipMissingButton, this.skipMissingIndicator, "skipMissing");
            this.fillToolTip(this.skipTilesButton, this.skipTilesIndicator, "skipTileEntities");
            this.fillToolTip(this.replaceLevelButtons.get(0), this.replaceLevelIndicators.get(0), "dontReplaceSolid");
            this.fillToolTip(this.replaceLevelButtons.get(1), this.replaceLevelIndicators.get(1), "replaceWithSolid");
            this.fillToolTip(this.replaceLevelButtons.get(2), this.replaceLevelIndicators.get(2), "replaceWithAny");
            this.fillToolTip(this.replaceLevelButtons.get(3), this.replaceLevelIndicators.get(3), "replaceWithEmpty");
        }
    }

    private void fillToolTip(IconButton button, Indicator indicator, String tooltipKey) {
        if (!button.method_25367()) {
            return;
        }
        boolean enabled = indicator.state == Indicator.State.ON;
        List<class_2561> tip = button.getToolTip();
        tip.add((class_2561)(enabled ? this.optionEnabled : this.optionDisabled).method_27662().method_27692(class_124.field_1078));
        tip.addAll(TooltipHelper.cutTextComponent((class_2561)Lang.translateDirect("gui.schematicannon.option." + tooltipKey + ".description", new Object[0]), class_124.field_1080, class_124.field_1080));
    }

    protected void method_2389(class_4587 ms, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.field_2800 + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height + 2;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.field_2776;
        int y = this.field_2800;
        BG_TOP.render(ms, x, y, (class_332)this);
        BG_BOTTOM.render(ms, x, y + SchematicannonScreen.BG_TOP.height, (class_332)this);
        SchematicannonTileEntity te = (SchematicannonTileEntity)((SchematicannonContainer)this.field_2797).contentHolder;
        this.renderPrintingProgress(ms, x, y, te.schematicProgress);
        this.renderFuelBar(ms, x, y, te.fuelLevel);
        this.renderChecklistPrinterProgress(ms, x, y, te.bookPrintingProgress);
        if (!te.inventory.getStackInSlot(0).method_7960()) {
            this.renderBlueprintHighlight(ms, x, y);
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + SchematicannonScreen.BG_TOP.width, y + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height - 48, -200.0f)).scale(5.0).render(ms);
        SchematicannonScreen.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(x + (SchematicannonScreen.BG_TOP.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        class_5250 msg = Lang.translateDirect("schematicannon.status." + te.statusMsg, new Object[0]);
        int stringWidth = this.field_22793.method_27525((class_5348)msg);
        if (te.missingItem != null) {
            stringWidth += 16;
            ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(te.missingItem).at(x + 128, y + 49, 100.0f)).scale(1.0).render(ms);
        }
        this.field_22793.method_30881(ms, (class_2561)msg, (float)(x + 103 - stringWidth / 2), (float)(y + 53), 0xCCDDFF);
        if ("schematicErrored".equals(te.statusMsg)) {
            this.field_22793.method_30881(ms, (class_2561)Lang.translateDirect("schematicannon.status.schematicErroredCheckLogs", new Object[0]), (float)(x + 103 - stringWidth / 2), (float)(y + 65), 0xCCDDFF);
        }
    }

    protected void renderBlueprintHighlight(class_4587 matrixStack, int x, int y) {
        AllGuiTextures.SCHEMATICANNON_HIGHLIGHT.render(matrixStack, x + 10, y + 60, (class_332)this);
    }

    protected void renderPrintingProgress(class_4587 matrixStack, int x, int y, float progress) {
        progress = Math.min(progress, 1.0f);
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS;
        sprite.bind();
        this.method_25302(matrixStack, x + 44, y + 64, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderChecklistPrinterProgress(class_4587 matrixStack, int x, int y, float progress) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_CHECKLIST_PROGRESS;
        sprite.bind();
        this.method_25302(matrixStack, x + 154, y + 20, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderFuelBar(class_4587 matrixStack, int x, int y, float amount) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_FUEL;
        if (((SchematicannonTileEntity)((SchematicannonContainer)this.field_2797).contentHolder).hasCreativeCrate) {
            AllGuiTextures.SCHEMATICANNON_FUEL_CREATIVE.render(matrixStack, x + 36, y + 19, (class_332)this);
            return;
        }
        sprite.bind();
        this.method_25302(matrixStack, x + 36, y + 19, sprite.startX, sprite.startY, (int)((float)sprite.width * amount), sprite.height);
    }

    @Override
    protected void renderForeground(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        SchematicannonTileEntity te = (SchematicannonTileEntity)((SchematicannonContainer)this.field_2797).contentHolder;
        int x = this.field_2776;
        int y = this.field_2800;
        int fuelX = x + 36;
        int fuelY = y + 19;
        if (mouseX >= fuelX && mouseY >= fuelY && mouseX <= fuelX + AllGuiTextures.SCHEMATICANNON_FUEL.width && mouseY <= fuelY + AllGuiTextures.SCHEMATICANNON_FUEL.height) {
            List<class_2561> tooltip = this.getFuelLevelTooltip(te);
            this.method_30901(matrixStack, tooltip, mouseX, mouseY);
        }
        if (this.field_2787 != null && !this.field_2787.method_7681()) {
            if (this.field_2787.field_7874 == 0) {
                this.method_30901(matrixStack, TooltipHelper.cutTextComponent((class_2561)Lang.translateDirect("gui.schematicannon.slot.schematic", new Object[0]), class_124.field_1080, class_124.field_1078), mouseX, mouseY);
            }
            if (this.field_2787.field_7874 == 2) {
                this.method_30901(matrixStack, TooltipHelper.cutTextComponent((class_2561)Lang.translateDirect("gui.schematicannon.slot.listPrinter", new Object[0]), class_124.field_1080, class_124.field_1078), mouseX, mouseY);
            }
            if (this.field_2787.field_7874 == 4) {
                this.method_30901(matrixStack, TooltipHelper.cutTextComponent((class_2561)Lang.translateDirect("gui.schematicannon.slot.gunpowder", new Object[0]), class_124.field_1080, class_124.field_1078), mouseX, mouseY);
            }
        }
        if (te.missingItem != null) {
            int missingBlockX = x + 128;
            int missingBlockY = y + 49;
            if (mouseX >= missingBlockX && mouseY >= missingBlockY && mouseX <= missingBlockX + 16 && mouseY <= missingBlockY + 16) {
                this.method_25409(matrixStack, te.missingItem, mouseX, mouseY);
            }
        }
        int paperX = x + 112;
        int paperY = y + 19;
        if (mouseX >= paperX && mouseY >= paperY && mouseX <= paperX + 16 && mouseY <= paperY + 16) {
            this.method_25424(matrixStack, this.listPrinter, mouseX, mouseY);
        }
        super.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected List<class_2561> getFuelLevelTooltip(SchematicannonTileEntity te) {
        double fuelUsageRate = te.getFuelUsageRate();
        int shotsLeft = (int)((double)te.fuelLevel / fuelUsageRate);
        int shotsLeftWithItems = (int)((double)shotsLeft + (double)te.inventory.getStackInSlot(4).method_7947() * (te.getFuelAddedByGunPowder() / fuelUsageRate));
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (te.hasCreativeCrate) {
            tooltip.add((class_2561)Lang.translateDirect("gui.schematicannon.gunpowderLevel", "100"));
            tooltip.add((class_2561)Components.literal("(").method_10852((class_2561)((CreativeCrateBlock)AllBlocks.CREATIVE_CRATE.get()).method_9518()).method_27693(")").method_27692(class_124.field_1064));
            return tooltip;
        }
        int fillPercent = (int)(te.fuelLevel * 100.0f);
        tooltip.add((class_2561)Lang.translateDirect("gui.schematicannon.gunpowderLevel", fillPercent));
        tooltip.add((class_2561)Lang.translateDirect("gui.schematicannon.shotsRemaining", Components.literal(Integer.toString(shotsLeft)).method_27692(class_124.field_1078)).method_27692(class_124.field_1080));
        if (shotsLeftWithItems != shotsLeft) {
            tooltip.add((class_2561)Lang.translateDirect("gui.schematicannon.shotsRemainingWithBackup", Components.literal(Integer.toString(shotsLeftWithItems)).method_27692(class_124.field_1078)).method_27692(class_124.field_1080));
        }
        return tooltip;
    }

    protected void sendOptionUpdate(ConfigureSchematicannonPacket.Option option, boolean set) {
        AllPackets.channel.sendToServer((C2SPacket)new ConfigureSchematicannonPacket(option, set));
    }

    @Override
    public List<class_768> getExtraAreas() {
        return this.extraAreas;
    }
}

